package ru.yandex.calendar.frontend.web.cmd.run.api;

import Yandex.RequestPackage.RequestData;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ReqProcessingXmlCommand;
import ru.yandex.calendar.logic.event.EventRoutines;
import ru.yandex.calendar.logic.event.RequestEventDataConverter;
import ru.yandex.calendar.logic.event.dao.EventDao;
import ru.yandex.calendar.logic.event.model.EventData;
import ru.yandex.calendar.logic.notification.NotificationsData;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;
import ru.yandex.calendar.util.data.DataProvider;
import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.inside.passport.PassportSid;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author ssytnik
 */
public class CmdSvcAddEvent extends ReqProcessingXmlCommand {
    private static final Logger logger = LoggerFactory.getLogger(CmdSvcAddEvent.class);
    private static final String CMD_TAG = "service-add-event";

    @Autowired
    private EventRoutines eventRoutines;
    @Autowired
    private EventDao eventDao;
    @Autowired
    private TransactionTemplate transactionTemplate;


    public CmdSvcAddEvent(AuthInfo ai, RequestData requestData) {
        super(CMD_TAG, requestData, ai);
        //setRequiresDbTransaction(false);
    }

    @Override
    protected void buildXmlResponseRP(final XmlCmdContext ctx, final AliasedRequestDataProvider dp) {
        DataProvider gDp = dp.getDataProvider("general", true);
        final PassportSid sid = new PassportSid(Integer.parseInt(gDp.getText("sid", true)));
        // Customize dtf (override timezone) if needed

        DateTimeZone tz0 = tz;

        String timezoneId = gDp.getText("timezone", false);
        if (StringUtils.isNotEmpty(timezoneId)) {
            tz0 = AuxDateTime.getVerifyDateTimeZone(timezoneId);
        }

        final DateTimeZone tz = tz0;

        transactionTemplate.execute(new TransactionCallback<Void>() {
            public Void doInTransaction(TransactionStatus status) {
                // Get data providers
                DataProvider uDp = dp.getDataProvider("user", false), drDp;
                DataProvider eDp = dp.getDataProvider("event", false);

                // Create layer/layer_user, event/event_user
                if (eDp != null) {
                    EventData eventData = RequestEventDataConverter.convert(tz, tz, eDp, uDp);
                    eventRoutines.createServiceEventIfNotExists(uidO.get(), sid, eventData,
                            NotificationsData.createFromWeb(eventData.getEventUserData().getNotifications()),
                            getActionInfo());
                }
                return null;
            }
        });
    } // buildXml
}
