package ru.yandex.calendar.frontend.web.cmd.run.api;

import Yandex.RequestPackage.RequestData;
import org.jdom.Element;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ReqProcessingXmlCommand;
import ru.yandex.calendar.logic.svc.DbSvcRoutines;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;
import ru.yandex.calendar.util.data.DataProvider;
import ru.yandex.calendar.util.dates.DateTimeFormatter;
import ru.yandex.calendar.util.db.CalendarJdbcTemplate;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.inside.passport.PassportSid;

/**
 * Accepts: g=1, g_sid, f=1, f_since_day=date, f_until_day=date
 * Ignores: f_is_with_event_ext_ids[=1]
 * @author ssytnik
 */
public class CmdSvcCheckSubscr extends ReqProcessingXmlCommand {
    private static final String CMD_TAG = "service-check-subscription";

    @Autowired
    private CalendarJdbcTemplate jdbcTemplate;

    public CmdSvcCheckSubscr(AuthInfo ai, RequestData requestData) {
        super(CMD_TAG, requestData, ai);
    }

    @Override
    protected void buildXmlResponseRP(XmlCmdContext ctx, AliasedRequestDataProvider dp) {
        Element eRoot = ctx.getRootElement();

        DataProvider gDp = dp.getDataProvider("general", true);
        Element general = CalendarXmlizer.appendElm(eRoot, "general");

        PassportSid sid = new PassportSid(DbSvcRoutines.getSid(gDp));
        DbSvcRoutines.appendSidElm(general, sid);

        DataProvider fDp = dp.getDataProvider("filter", true);
        DateTime sinceTs = DateTimeFormatter.toNullableDateUnsafe(fDp.getText("since-day", true)).toDateTimeAtStartOfDay(tz);
        DateTime untilTs = DateTimeFormatter.toNullableDateUnsafe(fDp.getText("until-day", true)).toDateTimeAtStartOfDay(tz);

        String sql =
            "SELECT DISTINCT me.external_id " +
            "FROM event e INNER JOIN main_event me ON me.id = e.main_event_id " +
            "WHERE e.creator_uid = ? AND e.sid = ? AND e.start_ts BETWEEN ? AND ?";
        ListF<String> externalIds = jdbcTemplate.queryForList(sql, String.class, uidO.get().getUid(), sid, sinceTs, untilTs);

        final Element eSubscriptions = CalendarXmlizer.appendElm(eRoot, "subscriptions");
        externalIds.forEach(new Function1V<String>() {
            public void apply(String a) {
                Element eSubscription = CalendarXmlizer.appendElm(eSubscriptions, "subscription");
                CalendarXmlizer.appendElm(eSubscription, "external-id", a);
            }
        });
    }
}
