package ru.yandex.calendar.frontend.web.cmd.run.api;

import Yandex.RequestPackage.RequestData;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ReqProcessingXmlCommand;
import ru.yandex.calendar.logic.beans.generated.Settings;
import ru.yandex.calendar.logic.beans.generated.SettingsFields;
import ru.yandex.calendar.logic.layer.LayerRoutines;
import ru.yandex.calendar.logic.notification.Notification;
import ru.yandex.calendar.logic.notification.NotificationXmlizer;
import ru.yandex.calendar.logic.svc.DbSvcRoutines;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;
import ru.yandex.calendar.util.data.DataProvider;
import ru.yandex.calendar.util.dates.DateTimeFormatter;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.inside.passport.PassportSid;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;

/**
 * Returns user default or general settings
 * @author ssytnik
 */
public class CmdSvcGetSettings extends ReqProcessingXmlCommand {
    private static final String CMD_TAG = "service-get-settings";

    @Autowired
    private SettingsRoutines settingsRoutines;
    @Autowired
    private LayerRoutines layerRoutines;

    public CmdSvcGetSettings(AuthInfo ai, RequestData requestData) {
        super(CMD_TAG, requestData, ai);
    }

    @Override
    protected void buildXmlResponseRP(XmlCmdContext ctx, AliasedRequestDataProvider dp) {
        DataProvider gDp = dp.getDataProvider("general", true); // for service domain name
        PassportSid sid = new PassportSid(DbSvcRoutines.getSid(gDp));

        // Create response

        Element eRoot = ctx.getRootElement();
        Element general = CalendarXmlizer.appendElm(eRoot, "general");
        DbSvcRoutines.appendSidElm(general, sid);

        Element eUser = new Element("user");
        final PassportUid uid = uidO.get();
        CalendarXmlizer.appendElm(eUser, "uid", uid.getUid());
        DateTimeFormatter.appendTzInfo(tz, eUser, "timezone", true, null);

        Settings s = settingsRoutines.getSettingsByUid(uid).getCommon();
        //String isEmailSetValue = XmlUtils.objToXmlStr(dtf, AuxBase.isSet(s.getEmail().getOrNull()));
        //eUser.addContent(new Element("is-email-set").setText(isEmailSetValue));
        s.appendXmlTo(eUser, tz,
                SettingsFields.EMAIL, SettingsFields.MAPS_ENABLED,
                SettingsFields.IS_EDITED, SettingsFields.VIEW_TYPE);
        // Temporary solution for https://jira.yandex-team.ru/browse/CAL-3947 (should be replaced by s.getLayerId())
        CalendarXmlizer.appendDtfElm(eUser, "layer-id", layerRoutines.getDefaultLayerId(uid).getOrNull(), tz);

        ListF<Email> emails = userManager.getEmailsByUid(uid);
        CalendarXmlizer.appendElmColl(eRoot, null, "email", emails);

        ListF<Notification> n = layerRoutines.getNotificationOrGetDefaultBySid(uid, sid);
        NotificationXmlizer.appendElmForCmdGetSettings(eUser, n, false);
        eRoot.addContent(eUser);
    }
}
