package ru.yandex.calendar.frontend.web.cmd.run.api;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.function.forhuman.Comparator;
import ru.yandex.calendar.logic.beans.generated.Office;
import ru.yandex.calendar.logic.resource.ResourceInfo;

/**
 * @author gutman
 */
public class ResourcesForStaffComparator implements Comparator<ResourceInfo> {

    private final Office office;

    public ResourcesForStaffComparator(Office office) {
        this.office = office;
    }

    @Override
    public int compare(ResourceInfo r1, ResourceInfo r2) {
        Office office1 = r1.getOffice();
        Office office2 = r2.getOffice();

        if (!office1.getCityName().equals(office2.getCityName())) {
            if (office1.getCityName().equals(office.getCityName())) {
                return -1;
            }
            if (office2.getCityName().equals(office.getCityName())) {
                return 1;
            }
        }
        if (office1.getId() == office2.getId()) {
            return Cf.Long.comparator().compare(r1.getResource().getId(), r2.getResource().getId());
        } else if (office1.getId() == office.getId()) {
            return -1;
        } else {
            return 1;
        }
    }

}
