package ru.yandex.calendar.frontend.web.cmd.run.auxiliary;

import Yandex.RequestPackage.RequestData;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ReqProcessingXmlCommand;
import ru.yandex.calendar.logic.event.EventInvitationManager;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;
import ru.yandex.calendar.util.data.DataProvider;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.enums.EnumResolver;
import ru.yandex.misc.lang.CamelWords;
import ru.yandex.misc.lang.StringUtils;

/**
 * By given keys, returns some auxiliary information.
 * Each key can accept some parameters for its work.
 * IMPORTANT: auth info is required for now (2009-07-08).
 * @author ssytnik
 */
public class CmdGetInfo extends ReqProcessingXmlCommand {
    private static final String CMD_TAG = "get-info";

    @Autowired
    private EventInvitationManager eventInvitationManager;

    private String keysStr;

    public CmdGetInfo(AuthInfo ai, RequestData requestData) { this(ai, requestData, null); }
    public CmdGetInfo(AuthInfo ai, String keysStr) { this(ai, null, keysStr); }

    private CmdGetInfo(AuthInfo ai, RequestData requestData, String keysStr) {
        super(CMD_TAG, requestData, ai);
        this.keysStr = keysStr;
        //setRequiresDbTransaction(false); // for all keys
    }

    @Override
    protected void buildXmlResponseRP(XmlCmdContext ctx, AliasedRequestDataProvider dp) {
        ListF<String> keys;
        if (dp != null) {
            keysStr = dp.getText("keys", true);
            keys = Cf.x(StringUtils.split(keysStr, ","));
        } else {
            keys = Cf.list();
        }
        for (String key : keys) {
            Key.findByXmlName(key).obtainInfo(this, ctx, dp, uidO.get());
        }
    }

    /**
     * Defines set of all possible keys, as well as
     * methods that obtain information by key names
     * @author ssytnik
     */
    private static enum Key {
        TODAY_INV_COUNT {
            @Override public void obtainInfoInner(
                    CmdGetInfo cmd, DataProvider dpRoot,
                    Element eMy, PassportUid uid) {
                CalendarXmlizer.setText(eMy, cmd.eventInvitationManager.getInvitationCountTodayUtc(uid));
            } // method
        };

        public static final EnumResolver<Key> R = EnumResolver.er(Key.class);

        // By given XML key name, returns Key value (or throws error)
        public static Key findByXmlName(String s) {
            return R.valueOf(s);
        }

        // Method returns a child data provider, according to current key name
        @SuppressWarnings("unused")
        protected DataProvider getMyDp(DataProvider dpRoot) {
            if (dpRoot == null) { throw new IllegalArgumentException("dpRoot is null"); }
            return dpRoot.getDataProvider(toXmlValue(), true);
        }
        // Returns xml name for this key
        public String toXmlValue() { return CamelWords.parse(this.name()).toXmlName(); }

        // Obtains information, possibly using 'uid' and info from 'dp',
        // and puts it as text or xml - to the new output tag, which is
        // created with the current key name at the root element tag.
        public void obtainInfo(CmdGetInfo cmd, XmlCmdContext ctx, DataProvider dp, PassportUid uid) {
            Element eMy = new Element(toXmlValue());
            ctx.getRootElement().addContent(eMy);
            obtainInfoInner(cmd, dp, eMy, uid);
        }
        // Implementation depends on key
        public abstract void obtainInfoInner(
                CmdGetInfo cmd, DataProvider dpRoot,
                Element eMy, PassportUid uid);
    }
}
