package ru.yandex.calendar.frontend.web.cmd.run.auxiliary;

import Yandex.Tag;
import Yandex.TagHolder;
import org.jdom.Element;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Hours;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.XmlCommand;
import ru.yandex.calendar.util.dates.TimeZones;
import ru.yandex.calendar.util.xml.CalendarXmlizer;

/**
 * @author Daniel Brylev
 */
public class CmdGetTimezones extends XmlCommand {
    private static final Duration CACHE_INTERVAL = Hours.THREE.toStandardDuration();

    private final TagHolder tag;

    public CmdGetTimezones(TagHolder tag) {
        super("get-timezones");
        this.tag = tag;
    }

    @Override
    protected void buildXmlResponse(XmlCmdContext ctx) {
        Instant now = Instant.now();
        tag.value = new Tag();

        for (Tuple2<DateTimeZone, String> t : TimeZones.getDescriptionsSortedByOffset(now)) {
            Element timezoneElement = CalendarXmlizer.appendElm(ctx.getRootElement(), "timezone");
            CalendarXmlizer.appendElm(timezoneElement, "id", t.get1().getID());
            CalendarXmlizer.appendElm(timezoneElement, "description", t.get2());
        }

        tag.value.lastModified = (int) (now.getMillis() / 1000);
        tag.value.expireTime = (int) (now.plus(CACHE_INTERVAL).getMillis() / 1000);
        tag.value.notModified = false;
    }
}
