package ru.yandex.calendar.frontend.web.cmd.run.ui;

import Yandex.RequestPackage.RequestData;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.generic.UserXmlCommand;
import ru.yandex.calendar.frontend.web.cmd.run.CommandRunException;
import ru.yandex.calendar.frontend.web.cmd.run.Situation;
import ru.yandex.calendar.logic.event.EventInvitationManager;
import ru.yandex.calendar.logic.sharing.participant.ParticipantId;
import ru.yandex.calendar.logic.sharing.participant.UserParticipantInfo;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.StringUtils;

public abstract class AbstractEventInvitationCommand extends UserXmlCommand {

    @Autowired
    private EventInvitationManager eventInvitationManager;
    @Autowired
    private SettingsRoutines settingsRoutines;

    private final Option<Long> eventIdO; // XXX must be mandatory
    private final Option<String> privateTokenO;

    public AbstractEventInvitationCommand(String cmdTag, AuthInfo ai, String privateToken, String eventId, RequestData requestData) {
        super(cmdTag, requestData, ai);
        // XXX move
        eventIdO = StringUtils.notEmptyO(eventId).map(Cf.Long::parse);
        privateTokenO = StringUtils.notEmptyO(privateToken);
        setMustHaveAuth(privateToken.isEmpty());
    }

    private UserParticipantInfo participant;
    protected UserParticipantInfo getParticipant() {
        if (participant != null) {
            return participant;
        }
        UserParticipantInfo participant;
        if (!privateTokenO.isPresent()) {
            final Long eventId = eventIdO.get();
            participant = (UserParticipantInfo) eventInvitationManager
                    .getParticipantByEventIdAndParticipantId(eventId, ParticipantId.yandexUid(uidO.get()))
                    .getOrThrow(CommandRunException.createSituationF(
                            "invitation not found by event id " + eventId + " and uid : " + uidO.get(),
                            Situation.INV_IS_MISSING)
                    );
        } else {
            String privateToken = privateTokenO.get();
            participant = eventInvitationManager.getUserParticipantByPrivateToken(privateToken)
                    .getOrThrow(CommandRunException.createSituationF(
                            "participant not found by private token: " + privateToken,
                            Situation.INV_IS_MISSING)
                );
        }
        this.participant = participant;
        return participant;
    }

    @Override
    protected Option<DateTimeZone> getTimezone() {
        Option<DateTimeZone> tzO = super.getTimezone();
        if (tzO.isPresent()) {
            return tzO;
        } else {
            Option<PassportUid> uidO = getParticipant().getUid();
            return Option.of(settingsRoutines.getTzData(uidO));
        }
    }
}
