package ru.yandex.calendar.frontend.web.cmd.run.ui;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.UserXmlCommand;
import ru.yandex.calendar.logic.ics.feed.IcsFeedManager;

/**
 * @author Daniel Brylev
 */
public class CmdForceFeedUpdate extends UserXmlCommand {
    private static final String CMD_TAG = "force-feed-update";

    @Autowired
    private IcsFeedManager icsFeedManager;

    private final long feedId;

    public CmdForceFeedUpdate(AuthInfo ai, long feedId) {
        super(CMD_TAG, ai);
        this.feedId = feedId;
    }

    @Override
    protected void buildXmlResponseU(XmlCmdContext ctx) {
        icsFeedManager.forceIcsFeedUpdate(uidO.get(), feedId);
    }
}
