package ru.yandex.calendar.frontend.web.cmd.run.ui;

import org.jdom.Element;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.beans.generated.EventUserFields;
import ru.yandex.calendar.logic.event.EventInvitationManager;
import ru.yandex.calendar.logic.event.EventRoutines;
import ru.yandex.calendar.logic.event.repetition.RepetitionInstanceInfo;
import ru.yandex.calendar.logic.event.repetition.RepetitionRoutines;
import ru.yandex.calendar.logic.event.repetition.RepetitionUtils;
import ru.yandex.calendar.logic.notification.EventNotifications;
import ru.yandex.calendar.logic.notification.EventUserWithNotifications;
import ru.yandex.calendar.logic.notification.NotificationDbManager;
import ru.yandex.calendar.logic.notification.NotificationXmlizer;
import ru.yandex.calendar.logic.sending.EventMarkupXmlCreator;
import ru.yandex.calendar.logic.sending.EventMarkupXmlCreator.EventXmlCreationInfo;
import ru.yandex.calendar.logic.sharing.InvitationXmlizer;
import ru.yandex.calendar.logic.sharing.participant.Participants;
import ru.yandex.calendar.logic.sharing.participant.UserParticipantInfo;
import ru.yandex.calendar.util.base.Cf2;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.time.InstantInterval;

// XXX: split into layer invitation and event invitation
public class CmdGetInvitation extends AbstractEventInvitationCommand {
    private static final String CMD_TAG = "get-invitation";
    private static final String SHARED_TAG = "shared";

    @Autowired
    private EventRoutines eventRoutines;
    @Autowired
    private EventInvitationManager eventInvitationManager;
    @Autowired
    private EventMarkupXmlCreator eventMarkupXmlCreator;
    @Autowired
    private NotificationDbManager notificationDbManager;
    @Autowired
    private RepetitionRoutines repetitionRoutines;


    public CmdGetInvitation(AuthInfo ai, String privateToken, String eventId) {
        super(CMD_TAG, ai, privateToken, eventId, null);
    }

    @Override
    protected void buildXmlResponseU(XmlCmdContext ctx) {
        UserParticipantInfo participant = getParticipant();

        Element eRoot = ctx.getRootElement();
        Instant now = getActionInfo().getNow();

        long eId = participant.getEventId();
        Participants participants = eventInvitationManager.getParticipantsByEventId(eId);
        EventXmlCreationInfo eInfo = eventRoutines.getEventXmlCreationInfo(eId);
        eRoot.addContent(eventMarkupXmlCreator.createEventVerstkaXml(eInfo, tz));
        // Append event_user if user was logged and has eu
        if (uidO.isPresent()) {
            Option<EventUserWithNotifications> pairO = notificationDbManager
                    .getEventUserWithNotificationsByUidAndEventId(uidO.get(), eInfo.getEvent().getId());
            if (pairO.isPresent()) {
                EventUser eventUser = pairO.get().getEventUser();
                Element eUser = new Element("user");
                eventUser.appendXmlTo(eUser, tz,
                        EventUserFields.AVAILABILITY, EventUserFields.COMPLETION,
                        EventUserFields.PRIORITY, EventUserFields.IS_SUBSCRIBER);
                EventNotifications notifications = pairO.get().getNotifications();
                NotificationXmlizer.appendElmForWeb(eUser, notifications.getNotifications());
                eRoot.addContent(eUser);
            }
        }
        eRoot.addContent(InvitationXmlizer.serializeParticipants(participants, uidO));
        appendSharedTag(eId, eRoot);

        ListF<Long> eventIds = Cf.list(eId);
        if (!eInfo.getEvent().getRecurrenceId().isPresent()) {
            eventIds = eventIds.plus(eventInvitationManager.findNotRejectedFutureEventIds(
                    participant.getId(), eInfo.getEvent().getMainEventId(), getActionInfo()));
        }
        Tuple2List<Long, RepetitionInstanceInfo> repetitions = repetitionRoutines
                .getRepetitionInstanceInfosByEventIds(eventIds).entries();
        Tuple2List<Long, InstantInterval> closestInstances = Cf2.flatBy2(
                repetitions.map2(RepetitionUtils.getClosestInstanceIntervalF(now)));

        Function<Tuple2<Long, InstantInterval>, Instant> endF = t -> t.get2().getEnd();
        Function1B<Tuple2<Long, InstantInterval>> endsAfterNowF = endF.andThen(Cf2.f1B(ts -> ts.isAfter(now)));

        Option<Tuple2<Long, InstantInterval>> closestInstance =
                closestInstances.filter(endsAfterNowF).minO(endF.andThenNaturalComparator())
                        .orElse(closestInstances.filter(endsAfterNowF.notF()).maxO(endF.andThenNaturalComparator()));

        if (closestInstance.isPresent()) {
            CalendarXmlizer.appendElm(eRoot, "closest-event-id", closestInstance.get().get1());
            CalendarXmlizer.appendDtfElm(eRoot, "closest-event-start-ts", closestInstance.get().get2().getStart(), tz);
        }
    }

    private void appendSharedTag(long id, Element eRoot) {
        if (uidO.isPresent()) {
            if (eventRoutines.isShared(uidO.get(), id)) {
                CalendarXmlizer.appendElm(eRoot, SHARED_TAG);
            }
        }
    }
}
