package ru.yandex.calendar.frontend.web.cmd.run.ui.event;

import org.jdom.Comment;
import org.jdom.Element;
import org.joda.time.DateTimeZone;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.cmd.run.ui.resource.ResourceXmlizer;
import ru.yandex.calendar.logic.event.avail.AvailabilityInterval;
import ru.yandex.calendar.logic.resource.ResourceInfo;
import ru.yandex.calendar.logic.sharing.InvitationXmlizer;
import ru.yandex.calendar.util.dates.DateTimeFormatter;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author Stepan Koltsov
 */
public class AvailabilityXmlizer {

    public static Element serializeAvailabilityInterval(Option<PassportUid> uidO, AvailabilityInterval interval, DateTimeZone tz, boolean outParticipants) {
        Element intervalElement = new Element("interval");
        intervalElement.setAttribute("start-ts", DateTimeFormatter.formatForMachines(interval.getInterval().getStart(), tz));
        intervalElement.setAttribute("end-ts", DateTimeFormatter.formatForMachines(interval.getInterval().getEnd(), tz));
        intervalElement.setAttribute("availability", interval.getAvailability().toDbValue());

        if (interval.getEventId().isPresent()) {
            intervalElement.setAttribute("event-id", interval.getEventId().get().toString());
        }
        if (interval.getEventName().isPresent()) {
            intervalElement.setAttribute("event-name", interval.getEventName().get());
        } else {
            intervalElement.addContent(new Comment("event name is not visible to client"));
        }
        if (interval.getInstanceStartTs().isPresent()) {
            intervalElement.setAttribute("instance-start-ts",
                    DateTimeFormatter.formatForMachines(interval.getInstanceStartTs().get(), DateTimeZone.UTC));
        }
        if (interval.getEventInterval().isPresent()) {
            intervalElement.setAttribute("event-end-ts", DateTimeFormatter.formatLocalDateTimeForMachines(
                    interval.getEventInterval().get().getEnd().toLocalDateTime(tz)));
        }

        if (outParticipants && interval.getParticipants().isPresent()) {
            intervalElement.addContent(InvitationXmlizer.serializeParticipants(interval.getParticipants().get(), uidO));
        }
        // XXX put to common <resources> tag, like we do for <participants>
        for (ResourceInfo resource : interval.getResources()) {
            intervalElement.addContent(ResourceXmlizer.toXml(resource));
        }
        return intervalElement;
    }

} //~
