package ru.yandex.calendar.frontend.web.cmd.run.ui.event;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.UserXmlCommand;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.event.web.EventWebManager;
import ru.yandex.calendar.logic.notification.NotificationsData;

public class CmdAttachEvent extends UserXmlCommand {
    private static final String CMD_TAG = "attach-event";

    @Autowired
    private EventWebManager eventWebManager;

    private final long eventId;

    public CmdAttachEvent(AuthInfo ai, long eventId) {
        super(CMD_TAG, ai);
        this.eventId = eventId;
    }

    @Override
    protected void buildXmlResponseU(XmlCmdContext ctx) {
        EventUser eventUser = new EventUser();
        eventUser.setIsSubscriber(true);

        eventWebManager.attachEvent(userInfoO.get(), eventId, Option.empty(),
                eventUser, NotificationsData.useLayerDefaultIfCreate(), getActionInfo());
    }

}
