package ru.yandex.calendar.frontend.web.cmd.run.ui.event;

import Yandex.RequestPackage.RequestData;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.RequestDataConverter;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.UserXmlCommand;
import ru.yandex.calendar.logic.beans.generated.EventFields;
import ru.yandex.calendar.logic.event.EventRoutines;
import ru.yandex.calendar.logic.event.RequestEventDataConverter;
import ru.yandex.calendar.logic.event.model.EventData;
import ru.yandex.calendar.logic.event.web.EventWebManager;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;
import ru.yandex.calendar.util.data.DataProvider;
import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.calendar.util.validation.Captcha;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author gutman
 */
public class CmdCreateOrUpdateEvent extends UserXmlCommand {
    private static final String CMD_TAG = "create-or-update-event";

    @Autowired
    private EventWebManager eventWebManager;
    @Autowired
    private EventCmdManager eventCmdManager;


    public CmdCreateOrUpdateEvent(AuthInfo ai, RequestData requestData) {
        super(CMD_TAG, requestData, ai);
        //setRequiresDbTransaction(false);
    }

    @Override
    public Duration getTimeout() {
        return Duration.standardSeconds(29);
    }

    @Override
    protected void buildXmlResponseU(XmlCmdContext ctx) {
        DataProvider dataProvider = new AliasedRequestDataProvider(rw);

        DataProvider eventDataProvider = dataProvider.getDataProvider("event", true);
        String timezoneId = eventDataProvider.getText("timezone", false);

        if (StringUtils.isNotEmpty(timezoneId)) {
            tz = AuxDateTime.getVerifyDateTimeZone(timezoneId);
        }
        Option<Long> id = Option.ofNullable(eventDataProvider.getText("id", false)).map(Cf.Long::parse);
        Option<DateTimeZone> eventTz = eventWebManager.getEventTimezoneIfExists(id);

        EventData eventData = RequestEventDataConverter.convertAndValidate(tz, eventTz.getOrElse(tz), eventDataProvider);

        if (eventData.getEvent().isFieldSet(EventFields.ID)) {
            boolean applyToFuture = EventRoutines.getApplyToFuture(eventDataProvider);
            eventWebManager.update(userInfoO.get(), eventData, applyToFuture, getActionInfo());
        } else {
            Option<Captcha.CaptchaData> captchaData = Option.empty();
            boolean hasInvitations = StringUtils.isNotEmpty(eventDataProvider.getText("invitations", false));
            if (hasInvitations) {
                captchaData = Option.of(RequestDataConverter.convertCaptchaData(eventDataProvider));
            }
            eventCmdManager.createEvent(ctx, eventData, captchaData, tz, uidO.get(), getActionInfo());
        }
    }

}
