package ru.yandex.calendar.frontend.web.cmd.run.ui.event;

import org.jdom.Element;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.UserXmlCommand;
import ru.yandex.calendar.logic.event.ModificationInfo;
import ru.yandex.calendar.logic.event.web.EventWebManager;
import ru.yandex.calendar.util.base.Binary;
import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.calendar.util.dates.DateTimeFormatter;

/**
 * @author dbrylev
 */
public class CmdDeleteEventResource extends UserXmlCommand {

    private static final String CMD_TAG = "delete-event-resource";

    @Autowired
    private EventWebManager eventWebManager;

    private final String exchangeName;
    private final long eventId;
    private final String eventTsStr;
    private final String applyToFutureEventsStr;
    private final int sequence;

    public CmdDeleteEventResource(
            AuthInfo authInfo, String exchangeName, long eventId,
            String eventTsStr, String applyToFutureEventsStr, int sequence)
    {
        super(CMD_TAG, authInfo);
        this.exchangeName = exchangeName;
        this.eventId = eventId;
        this.applyToFutureEventsStr = applyToFutureEventsStr;
        this.eventTsStr = eventTsStr;
        this.sequence = sequence;
    }

    @Override
    protected void buildXmlResponseU(XmlCmdContext ctx) {
        final Element rootElement = ctx.getRootElement();

        Instant eventTs = DateTimeFormatter.toNullableTimestampUnsafe(eventTsStr, DateTimeZone.UTC);
        Option<Instant> eventStartTs = Option.ofNullable(AuxDateTime.getMsNullable(eventTs)).map(Instant::new);
        boolean applyToFutureEvents = Binary.parseBoolean(applyToFutureEventsStr);

        ModificationInfo mi = eventWebManager.deleteEventResource(
                userInfoO.get(), exchangeName, eventId, sequence,
                eventStartTs, applyToFutureEvents, getActionInfo());

        mi.appendXmlTo(rootElement, true);
    }
}
