package ru.yandex.calendar.frontend.web.cmd.run.ui.event;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ValidatableXmlCommand;
import ru.yandex.calendar.logic.event.reminders.RemindersClient;
import ru.yandex.calendar.util.validation.RequestValidator;

/**
 * @author dbrylev
 */
public class CmdDeleteReminder extends ValidatableXmlCommand {
    private static final String CMD_TAG = "delete-reminder";

    @Autowired
    private RemindersClient remindersClient;

    private final String clientId;
    private final String externalId;
    private final String idxStr;

    public CmdDeleteReminder(AuthInfo ai, String clientId, String externalId, String idxStr) {
        super(CMD_TAG, ai);
        this.clientId = clientId;
        this.externalId = externalId;
        this.idxStr = idxStr;
    }

    @Override
    protected void validate() {
        RequestValidator.validateRequired(RequestValidator.LONG, "idx", idxStr);
    }

    @Override
    protected void buildXmlResponseV(XmlCmdContext ctx) {
        remindersClient.deleteEvent(uidO.get(), clientId, externalId, Long.parseLong(idxStr));
    }
}
