package ru.yandex.calendar.frontend.web.cmd.run.ui.event;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ValidatableXmlCommand;
import ru.yandex.calendar.logic.event.web.EventWebManager;
import ru.yandex.calendar.util.validation.RequestValidator;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class CmdDetachEvent extends ValidatableXmlCommand {
    private static final Logger logger = LoggerFactory.getLogger(CmdDetachEvent.class);

    private static final String CMD_TAG = "detach-event";

    @Autowired
    private EventWebManager eventWebManager;

    private final long eventId;
    private final long layerId;

    public CmdDetachEvent(AuthInfo ai, long eventId, long layerId) {
        super(CMD_TAG, ai);
        this.eventId = eventId;
        this.layerId = layerId;
    }

    @Override
    public void validate() {
        RequestValidator.validateRequired(RequestValidator.POSITIVE, "eventId", eventId);
        RequestValidator.validateRequired(RequestValidator.POSITIVE, "layerId", layerId);
    }

    @Override
    protected void buildXmlResponseV(XmlCmdContext ctx) {
        eventWebManager.detachEvent(userInfoO.get(), eventId, Option.of(layerId), getActionInfo());
    }
}
