package ru.yandex.calendar.frontend.web.cmd.run.ui.event;

import org.jdom.Text;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.caldav.proto.ETag;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.UserXmlCommand;
import ru.yandex.calendar.logic.beans.generated.Layer;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.ics.exp.IcsEventExporter;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.layer.LayerRoutines;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.inside.passport.PassportUid;

/**
 * NOTE: maybe rename to exportIcal
 * Export events (iCAL format)
 * @author ssytnik
 */
public class CmdExportEvents extends UserXmlCommand {
    private static final String CMD_TAG = "export-events";

    @Autowired
    private IcsEventExporter icsEventExporter;
    @Autowired
    private LayerRoutines layerRoutines;

    private Layer layer;
    private PassportUid uid2;
    private Option<Instant> lastModified;

    public CmdExportEvents(String tzId, String privateToken, Option<String> eTag) {
        super(CMD_TAG, tzId);
        this.lastModified = eTag.filterNot(String::isEmpty)
                .flatMapO(t -> Cf.Long.parseSafe(new ETag(t).unquoted().getValue()).map(Instant::new));

        setPrivateToken(privateToken);
    }

    @Override
    protected void obtainPrivateResource(String privateToken) {
        layer = layerRoutines.getByPrivateToken(privateToken);
        uid2 = layer.getCreatorUid();
    }

    @Override
    protected void buildXmlResponseU(XmlCmdContext ctx) {
        if (lastModified.exists(ts -> !layer.getCollLastUpdateTs().isAfter(ts))) {
            CalendarXmlizer.appendElm(ctx.getRootElement(), "not-modified");
            return;
        }
        IcsCalendar icsStr = icsEventExporter.exportCalendar(
                uid2, layer.getId(), getActionInfo().getNow(), ActionSource.WEB);

        CalendarXmlizer.setAttr(ctx.getRootElement(), "e-tag", Long.toString(layer.getCollLastUpdateTs().getMillis()));
        ctx.getRootElement().addContent(new Text(icsStr.serializeToString()));
    }
}
