package ru.yandex.calendar.frontend.web.cmd.run.ui.event;

import org.jdom.Element;
import org.joda.time.LocalDate;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ValidatableXmlCommand;
import ru.yandex.calendar.logic.event.repetition.RepetitionRoutines;
import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.calendar.util.dates.DateTimeFormatter;
import ru.yandex.calendar.util.validation.RequestValidator;

/**
 * For given date (optional; default: given user's 'today'),
 * prepares repetition hints and default repetition
 * @author ssytnik
 */
public class CmdGetDefRep extends ValidatableXmlCommand {
    private static final String CMD_TAG = "get-def-rep";

    private final String eventDateStr;

    public CmdGetDefRep(AuthInfo ai, String eventDateStr) {
        super(CMD_TAG, ai);
        this.eventDateStr = eventDateStr;
    }

    @Override
    public void validate() {
        RequestValidator.validateOptional(RequestValidator.DATE, "eventDate", eventDateStr);
    }

    @Override
    protected void buildXmlResponseV(XmlCmdContext ctx) {
        Element eRoot = ctx.getRootElement();

        debugLogXml(eRoot, "event date = ", "event-date", eventDateStr); // instead of 'eventDate' @ UTC
        LocalDate eventDate = DateTimeFormatter.toNullableDateUnsafe(eventDateStr);
        long dayStartMs = eventDate == null ? AuxDateTime.NOW() : eventDate.toDateTimeAtStartOfDay(tz).getMillis();
        RepetitionRoutines.addElms(eRoot, dayStartMs, null, tz);
    }
}
