package ru.yandex.calendar.frontend.web.cmd.run.ui.event;

import javax.annotation.Nullable;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.CmdGetEventBase;
import ru.yandex.calendar.logic.beans.generated.Layer;
import ru.yandex.calendar.logic.layer.LayerRoutines;
import ru.yandex.calendar.util.validation.RequestValidator;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.StringUtils;

/**
 * Get-event command which accepts <code>layerId</code>
 * (or <code>privateToken</code>) and <code>eventId</code>
 * and allows either authorized, or anonymous, user
 * @author ssytnik
 */
public class CmdGetEvent extends CmdGetEventBase {
    private static final String CMD_TAG = "get-event";

    private Option<PassportUid> uid2O;
    private Long layerId;
    private final long eventId;
    private final Option<String> linkSignKey;

    @Autowired
    private LayerRoutines layerRoutines;

    // uiGetEvent ctor
    public CmdGetEvent(
            AuthInfo ai,
            long layerId, long eventId,
            String eventTsStr, Option<Integer> sequence, String isForShowStr, @Nullable String linkSignKey)
    {
        super(CMD_TAG, ai, eventTsStr, sequence, isForShowStr);
        this.uid2O = uidO;
        this.layerId = layerId;
        this.eventId = eventId;
        this.linkSignKey = StringUtils.notEmptyO(linkSignKey);
    }
    // uiGetEventA ctor
    public CmdGetEvent(
            @Nullable AuthInfo ai, String tzId,
            long layerId, long eventId,
            String eventTsStr, Option<Integer> sequence, String isForShowStr, @Nullable String linkSignKey)
    {
        super(CMD_TAG, ai, eventTsStr, sequence, isForShowStr, tzId);
        setMustHaveAuth(ai != null);

        this.uid2O = uidO;
        this.layerId = layerId;
        this.eventId = eventId;
        this.linkSignKey = StringUtils.notEmptyO(linkSignKey);
    }
    // uiGetEventAP ctor
    public CmdGetEvent(
            String tzId,
            String privateToken, long eventId,
            String eventTsStr, Option<Integer> sequence, String isForShowStr, @Nullable String linkSignKey)
    {
        super(CMD_TAG, eventTsStr, sequence, isForShowStr, tzId);
        this.uid2O = Option.empty();
        this.layerId = null;
        this.eventId = eventId;
        this.linkSignKey = StringUtils.notEmptyO(linkSignKey);
        setPrivateToken(privateToken); // will set uid2, layerId
    }

    @Override
    protected void obtainPrivateResource(String privateToken) {
        Layer l = layerRoutines.getByPrivateToken(privateToken);
        this.uid2O = Option.of(l.getCreatorUid()); // as if layer creator was looking over his own layer
        this.layerId = l.getId();
        // eventId is initialized
    }

    // uiGetEvent3 ctor
    public CmdGetEvent(
            AuthInfo ai,
            long layerId, long eventId,
            String eventTsStr, String isForShowStr, String timezoneId)
    {
        super(CMD_TAG, ai, eventTsStr, Option.<Integer>empty(), isForShowStr, timezoneId);
        this.uid2O = uidO;
        this.layerId = layerId;
        this.eventId = eventId;
        this.linkSignKey = Option.empty();
    }

    @Override
    public void validate() {
        // XXX: eventTs must be optional
        RequestValidator.validateRequired(RequestValidator.TIMESTAMP, "eventTs", eventTsStr);
        // XXX: layerId must be optional
        //RequestValidator.validateRequired(RequestValidator.POSITIVE, "layerId", layerId);
        RequestValidator.validateRequired(RequestValidator.POSITIVE, "eventId", eventId);
    }

    @Override
    protected void buildXmlResponseV(XmlCmdContext ctx) {
        Option<Long> layerIdO = layerId > 0 ? Option.of(layerId) : Option.<Long>empty();
        buildGetEventXmlResponse(ctx, uid2O, layerIdO, eventId, linkSignKey);
    }

}
