package ru.yandex.calendar.frontend.web.cmd.run.ui.event;

import org.jdom.Element;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.UserXmlCommand;
import ru.yandex.calendar.logic.beans.generated.Event;
import ru.yandex.calendar.logic.beans.generated.Layer;
import ru.yandex.calendar.logic.beans.generated.Repetition;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.event.EventInstanceInfo;
import ru.yandex.calendar.logic.event.EventInvitationManager;
import ru.yandex.calendar.logic.event.EventRoutines;
import ru.yandex.calendar.logic.event.repetition.RepetitionRoutines;
import ru.yandex.calendar.logic.notification.EventNotifications;
import ru.yandex.calendar.logic.notification.EventUserWithNotifications;
import ru.yandex.calendar.logic.notification.NotificationXmlizer;
import ru.yandex.calendar.logic.sharing.InvitationXmlizer;
import ru.yandex.calendar.logic.sharing.participant.Participants;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.time.TimeUtils;

/**

 * @author gutman
 */
public class CmdGetEvent2 extends UserXmlCommand {
    private static final Logger logger = LoggerFactory.getLogger(CmdGetEvent2.class);

    private static final String CMD_TAG = "get-events";

    @Autowired
    private EventRoutines eventRoutines;
    @Autowired
    private RepetitionRoutines repetitionRoutines;
    @Autowired
    private EventInvitationManager eventInvitationManager;
    @Autowired
    private EventCmdManager eventCmdManager;

    private final Option<Instant> startTs;
    private final EventQuery eventQuery;
    private final Option<String> invitationToken;

    public CmdGetEvent2(AuthInfo ai, String privateToken, long eventId, String layerId, String startTsStr) {
        super(CMD_TAG, ai);

        invitationToken = StringUtils.notEmptyO(privateToken);
        eventQuery = new EventQuery(eventId, StringUtils.notEmptyO(layerId).map(Cf.Long::parse));

        if (StringUtils.isNotEmpty(startTsStr)) {
            startTs = Option.of(TimeUtils.instant.parse(startTsStr, DateTimeZone.UTC));
        } else {
            startTs = Option.empty();
        }

        setMustHaveAuth(StringUtils.isEmpty(privateToken));
    }

    @Override
    protected void buildXmlResponseU(XmlCmdContext ctx) {
        EventResponse eventResponse = eventCmdManager.getEvent(eventQuery, invitationToken, userInfoO, startTs);

        Event event = eventResponse.getInstanceInfo().getEvent();

        Option<EventNotifications> notifications = eventResponse
                .getInstanceInfo()
                .getEventUserWithNotifications()
                .map(EventUserWithNotifications.getNotificationsF());

        Option<Repetition> repetition = eventResponse.getInstanceInfo().getRepInstInfo().getRepetition();

        Participants invs = eventInvitationManager.getParticipantsByEventId(event.getId());

        Element response = ctx.getRootElement();
        EventInstanceInfo ei = eventResponse.getInstanceInfo();
        Option<Layer> layer = ei.getLayerId().filterMap(ei.getEventWithRelations()::findLayerById);
        Element eEvent = eventRoutines.getElement(
                userInfoO, ei, layer, Option.empty(), Option.empty(), tz, Option.<String>empty(), ActionSource.WEB);
        eEvent.addContent(InvitationXmlizer.serializeParticipants(invs, uidO));

        if (eventResponse.getLayerId().isPresent()) {
            Element eLayer = eEvent.getChild("layer");
            // PermXmlizer.appendPermElms(eLayer, permManager, user, layerId.get(), ActionSource.WEB, LayerAction.DETACH_EVENT);
            // XXX add needed layer actions flags
            if (notifications.isPresent()) {
                Element eUser = eEvent.getChild("user");
                NotificationXmlizer.appendElmForWeb(eUser, notifications.get().getNotifications());
            }
        }

        long startMillis = eventResponse.getInstanceInfo().getInterval().getStartMillis();
        RepetitionRoutines.addElms(eEvent, startMillis, repetition.getOrNull(), tz);

        response.addContent(eEvent);
    }

}


