package ru.yandex.calendar.frontend.web.cmd.run.ui.event;

import org.jdom.Text;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.UserXmlCommand;
import ru.yandex.calendar.frontend.web.cmd.run.CommandRunException;
import ru.yandex.calendar.frontend.web.cmd.run.PermissionDeniedUserException;
import ru.yandex.calendar.frontend.web.cmd.run.Situation;
import ru.yandex.calendar.logic.beans.generated.MainEvent;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.event.EventInfo;
import ru.yandex.calendar.logic.event.EventInfoDbLoader;
import ru.yandex.calendar.logic.event.MainEventInfo;
import ru.yandex.calendar.logic.event.dao.MainEventDao;
import ru.yandex.calendar.logic.ics.exp.IcsEventExporter;
import ru.yandex.calendar.logic.ics.exp.IcsExportMode;
import ru.yandex.calendar.logic.ics.exp.IcsExportParameters;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.ics.iv5j.ical.property.IcsMethod;
import ru.yandex.calendar.util.xml.CalendarXmlizer;

/**
 * @author dbrylev
 */
public class CmdGetEventIcs extends UserXmlCommand {
    private static final String CMD_TAG = "get-event-ics";

    private final long eventId;

    @Autowired
    private IcsEventExporter icsEventExporter;
    @Autowired
    private EventInfoDbLoader eventInfoDbLoader;
    @Autowired
    private MainEventDao mainEventDao;

    public CmdGetEventIcs(AuthInfo ai, long eventId) {
        super(CMD_TAG, ai);
        this.eventId = eventId;
    }

    @Override
    protected void buildXmlResponseU(XmlCmdContext ctx) {
        Option<MainEvent> mainEventO = mainEventDao.findMainEventsByEventIds(Cf.list(eventId)).singleO();

        if (!mainEventO.isPresent()) {
            throw CommandRunException.createSituation("event not found by id" + eventId, Situation.EVENT_NOT_FOUND);
        }

        MainEventInfo mainEventInfo = eventInfoDbLoader.getMainEventInfos(
                uidO, mainEventO, ActionSource.WEB).single();

        EventInfo eventInfo = mainEventInfo.getEventInfos().find(ei -> ei.getEventId() == eventId).get();

        if (!eventInfo.mayView()) {
            throw new PermissionDeniedUserException(uidO + " can not view event " + eventId);
        }
        ListF<EventInfo> eventsToExport;

        if (!eventInfo.getRecurrenceId().isPresent()) {
            eventsToExport = mainEventInfo.getEventInfos();

        } else if (mainEventInfo.getMasterEventInfos().exists(EventInfo::mayView)) {
            eventsToExport = mainEventInfo.getEventInfos();

        } else {
            eventsToExport = Cf.list(eventInfo);
        }
        IcsExportParameters exportParams = new IcsExportParameters(
                IcsExportMode.EMAIL, IcsMethod.PUBLISH, true, Instant.now());

        IcsCalendar ics = icsEventExporter.exportEvents(uidO.get(), eventsToExport, exportParams);

        CalendarXmlizer.setAttr(ctx.getRootElement(), "external-id", mainEventO.get().getExternalIdNormalized());
        ctx.getRootElement().addContent(new Text(ics.serializeToString()));
    }
}
