package ru.yandex.calendar.frontend.web.cmd.run.ui.event;

import org.jdom.Element;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ValidatableXmlCommand;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.event.EventInstanceInfo;
import ru.yandex.calendar.logic.event.EventRoutines;
import ru.yandex.calendar.logic.event.LayerIdPredicate;
import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.calendar.util.dates.DateTimeFormatter;
import ru.yandex.calendar.util.validation.RequestValidator;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.time.InstantInterval;

/**
 * ssytnik: this command is unused since 2009-04-09
 *
 * Returns information
 * Returns all events owned (created or shared) by current user.
 * In the future: OR user specified by uid.
 * - showDateStr - string representation of the date which must be included in the output
 * (if not set, then current date is used)
 * - viewType - "day", "week" or "month" (if not set, then "week" is used by default)
 *
 * @deprecated
 * @author ssytnik
 */
@Deprecated
public class CmdGetTimeline extends ValidatableXmlCommand {
    private static final String CMD_TAG = "get-timeline";
    private static final int PARTS_IN_DAY = 48; // must be divisor of 86,400,000 ms, be dividend of 8
    private static final int MARKER_GROUP_LENGTH = PARTS_IN_DAY / 8; // each 3rd hour
    private static final long PART_LENGTH = Duration.standardDays(1).getMillis() / PARTS_IN_DAY;

    @Autowired
    private EventRoutines eventRoutines;

    private final String showDateStr;

    // ssytnik: 2009-04-09: command is turned off now
    private CmdGetTimeline(AuthInfo ai, String showDateStr) {
        super(CMD_TAG, ai);
        this.showDateStr = showDateStr;
    }

    @Override
    public void validate() {
        RequestValidator.validateOptional(RequestValidator.DATE, "showDate", showDateStr);
    }

    @Override
    protected void buildXmlResponseV(XmlCmdContext ctx) {
        final Element rootElement = ctx.getRootElement();

        // Get incoming parameters from the request (or use defaults instead)

        final LocalDate showDate = StringUtils.isEmpty(showDateStr) ?
            new LocalDate(tz) :
            DateTimeFormatter.toNullableDateUnsafe(showDateStr);

        final Instant ms1 = showDate.toDateTimeAtStartOfDay(tz).toInstant();
        final Instant ms2 = showDate.plusDays(1).toDateTimeAtStartOfDay(tz).toInstant();

        // Add info to root element
        CalendarXmlizer.setDtfAttr(rootElement, "current-ts", AuxDateTime.NOWTS(), tz);
        CalendarXmlizer.setDtfAttr(rootElement, "show-date", showDate, tz);

        final LayerIdPredicate layerIdPredicate = LayerIdPredicate.allForUser(uidO.get(), false);
        ListF<EventInstanceInfo> eventInfos = eventRoutines.getSortedInstancesIMayView(uidO,
                ms1, Option.of(ms2), layerIdPredicate, ActionSource.WEB);
        // Special format rule: if not a single event found, return
        if (eventInfos.size() == 0) { return; }

        boolean[] isIntervalWithEvent = new boolean[PARTS_IN_DAY];
        for (EventInstanceInfo ei : eventInfos) {
            InstantInterval i = ei.getInterval();
            // Calculate event start and end milliseconds with [ms1 .. ms2) saturation
            long ems1 = Math.max(i.getStartMillis(), ms1.getMillis());
            long ems2 = Math.min(i.getEndMillis(), ms2.getMillis());
            if (ems1 < ems2) { // if equal, k2 could be negative
                long localMs1 = ems1 - ms1.getMillis();
                long localMs2 = ems2 - ms1.getMillis(); // ms difference from start
                // Calculate first and last interval indexes to mark as having event(s)
                int k1 = (int) (localMs1 / PART_LENGTH), k2 = (int) ((localMs2 - 1) / PART_LENGTH);
                for (int k = k1; k <= k2; ++k) { isIntervalWithEvent[k] = true; }
            } // if
        }

        // Generate XML output
        Element eIntervals = new Element("intervals");
        for (int k = 0; k < PARTS_IN_DAY; ++k) {
            Element eInterval = new Element("interval");
            CalendarXmlizer.setDtfAttr(eInterval, "time", LocalTime.fromMillisOfDay(k * PART_LENGTH), DateTimeZone.UTC);
            CalendarXmlizer.setAttr(eInterval, "has-events", isIntervalWithEvent[k]);
            if (k % MARKER_GROUP_LENGTH == 0) { CalendarXmlizer.setAttr(eInterval, "marker", "1"); }
            eIntervals.addContent(eInterval);
        }
        rootElement.addContent(eIntervals);
    } // buildXml method



}
