package ru.yandex.calendar.frontend.web.cmd.run.ui.event;

import Yandex.RequestPackage.RequestData;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.RequestDataConverter;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.run.ui.AbstractEventInvitationCommand;
import ru.yandex.calendar.logic.beans.generated.EventInvitationFields;
import ru.yandex.calendar.logic.beans.generated.EventUser;
import ru.yandex.calendar.logic.beans.generated.EventUserFields;
import ru.yandex.calendar.logic.event.avail.Availability;
import ru.yandex.calendar.logic.event.model.WebReplyData;
import ru.yandex.calendar.logic.event.web.EventWebManager;
import ru.yandex.calendar.logic.notification.NotificationsData;
import ru.yandex.calendar.logic.sharing.Decision;
import ru.yandex.calendar.logic.sharing.participant.UserParticipantInfo;
import ru.yandex.calendar.util.base.Binary;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;
import ru.yandex.calendar.util.data.DataProvider;
import ru.yandex.calendar.util.dates.DateTimeFormatter;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author akirakozov
 */
public class CmdHandleEventInvitationDecision extends AbstractEventInvitationCommand {
    private static final String CMD_TAG = "handle-inv-decision";
    private static final int MAX_REASON_LENGTH = 200;

    @Autowired
    private EventWebManager eventWebManager;

    public CmdHandleEventInvitationDecision(AuthInfo ai, RequestData requestData, String privateToken, String eventId) {
        super(CMD_TAG, ai, privateToken, eventId, requestData);
    }

    @Override
    protected void buildXmlResponseU(XmlCmdContext ctx) {
        AliasedRequestDataProvider dp = new AliasedRequestDataProvider(rw);

        Option<Long> layerIdO = Option.ofNullable(dp.getText("e-l-layer-id", false)).map(Cf.Long::parse);

        DataProvider userDp = dp.getDataProvider("user", false);
        EventUser eventUserData = RequestDataConverter.convertEventUser(userDp);
        Decision decision = Decision.R.valueOf(dp.getText(EventInvitationFields.DECISION.column().name(), true));

        // "truncate if longer"
        String str = StringUtils.substring(dp.getText(EventInvitationFields.REASON.column().name(), false), 0, MAX_REASON_LENGTH);
        Option<String> reason = StringUtils.notBlankO(str);

        UserParticipantInfo participant = getParticipant();

        NotificationsData.Create notifications = NotificationsData.useLayerDefaultIfCreate();

        Option<Availability> availability = eventUserData.getFieldValueO(EventUserFields.AVAILABILITY);
        WebReplyData reply = new WebReplyData(decision, reason, layerIdO, availability, notifications);

        Option<Instant> instanceStartTs = Option.ofNullable(
                DateTimeFormatter.toNullableTimestampUnsafe(dp.getText("e-ts", false), DateTimeZone.UTC));
        boolean applyToAll = Binary.parseBoolean(dp.getText("apply-to-future-events", false));

        eventWebManager.handleEventInvitationDecision(
                uidO.getOrThrow("No more anonymous replies"), participant,
                instanceStartTs, applyToAll, reply, getActionInfo());
    }
}
