package ru.yandex.calendar.frontend.web.cmd.run.ui.event;

import org.jdom.Comment;
import org.jdom.Element;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.UserXmlCommand;
import ru.yandex.calendar.util.dates.DateTimeFormatter;
import ru.yandex.calendar.util.dates.DateTimeManager;
import ru.yandex.calendar.util.dates.HumanReadableTimeParser;
import ru.yandex.calendar.util.dates.HumanReadableTimeParser.Result;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.lang.StringUtils;

public class CmdParseTimeInEventName extends UserXmlCommand {

    @Autowired
    private DateTimeManager dateTimeManager;

    private final String string;
    private final String date;

    public CmdParseTimeInEventName(AuthInfo ai, String string, String date) {
        super("time-in-event-name", ai);
        this.string = string;
        this.date = date;
    }

    @Override
    protected void buildXmlResponseU(XmlCmdContext ctx) {
        DateTimeZone tz = dateTimeManager.getTimeZoneForUid(uidO.get());

        Instant now = new Instant();

        LocalDateTime nowLocalDateTime = now.toDateTime(tz).toLocalDateTime();
        LocalDate referenceLocalDate;
        if (StringUtils.isNotEmpty(date)) {
            referenceLocalDate = DateTimeFormatter.parseLocalDateFromMachines(date);
        } else {
            referenceLocalDate = nowLocalDateTime.toLocalDate();
        }

        Result r = HumanReadableTimeParser.parse(string);
        Element element = CalendarXmlizer.appendElm(ctx.getRootElement(), "result");

        Duration defaultEventDuration = Duration.standardHours(1);

        LocalDateTime startDateTime;
        LocalDateTime endDateTime;

        if (r.gotSomething()) {
            startDateTime = r.getStartDateTime(referenceLocalDate);
            if (r.isAllDay()) {
                endDateTime = referenceLocalDate.plusDays(1).toLocalDateTime(LocalTime.MIDNIGHT);
            } else {
                endDateTime = startDateTime.plus(defaultEventDuration);
            }
        } else {
            element.addContent(new Comment("time in string not found"));
            boolean isToday = referenceLocalDate.equals(nowLocalDateTime.toLocalDate());
            if (isToday) {
                startDateTime = nowLocalDateTime
                    .plusHours(1)
                    .withMinuteOfHour(0)
                    .withSecondOfMinute(0);
            } else {
                startDateTime = referenceLocalDate.toLocalDateTime(new LocalTime(13, 0, 0));
            }
            endDateTime = startDateTime.plus(defaultEventDuration);
        }

        CalendarXmlizer.appendElm(element, EventXmlizer.IS_ALL_DAY_NAME, r.isAllDay());
        CalendarXmlizer.appendElm(element, EventXmlizer.START_TS_NAME, startDateTime);
        CalendarXmlizer.appendElm(element, EventXmlizer.END_TS_NAME, endDateTime);
        CalendarXmlizer.appendElm(element, EventXmlizer.NAME_NAME, r.getRest());

    }

} //~
