package ru.yandex.calendar.frontend.web.cmd.run.ui.event;

import Yandex.RequestPackage.RequestData;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ReqProcessingXmlCommand;
import ru.yandex.calendar.logic.event.EventRoutines;
import ru.yandex.calendar.logic.event.RequestEventDataConverter;
import ru.yandex.calendar.logic.event.model.EventData;
import ru.yandex.calendar.logic.event.web.EventWebManager;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;
import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author ssytnik
 */
public class CmdUpdateEvent extends ReqProcessingXmlCommand {
    private static final String CMD_TAG = "update-event";

    @Autowired
    private EventWebManager eventWebManager;

    public CmdUpdateEvent(AuthInfo ai, RequestData requestData) {
        super(CMD_TAG, requestData, ai);
        //setRequiresDbTransaction(false);
    }

    // id validation will be implicitly made at bean creation

    @Override
    protected void buildXmlResponseRP(XmlCmdContext ctx, AliasedRequestDataProvider dp) {
        String timezoneId = dp.getDataProvider("event", true).getText("timezone", false);
        if (StringUtils.isNotEmpty(timezoneId)) {
            tz = AuxDateTime.getVerifyDateTimeZone(timezoneId);
        }
        String idStr = dp.getDataProvider("event", true).getText("id", true);
        Option<DateTimeZone> eventTz = eventWebManager.getEventTimezoneIfExists(Option.of(Long.parseLong(idStr)));

        EventData eventData = RequestEventDataConverter.convertAndValidate(tz, eventTz.getOrElse(tz), dp);
        Option<Integer> sequence = Option.ofNullable(dp.getText("sequence", false)).map(Cf.Integer::parse);

        boolean applyToFuture = EventRoutines.getApplyToFuture(dp);
        eventWebManager.update(userInfoO.get(), eventData, sequence, applyToFuture, getActionInfo());
    }
}
