package ru.yandex.calendar.frontend.web.cmd.run.ui.event.attachment;

import Yandex.Request;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.UserXmlCommand;
import ru.yandex.calendar.frontend.web.cmd.run.CommandRunException;
import ru.yandex.calendar.logic.event.attachment.MulcaGate;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Daniel Brylev
 */
public class CmdDownloadAttachment extends UserXmlCommand {
    private static final Logger logger = LoggerFactory.getLogger(CmdDownloadAttachment.class);
    private static final String CMD_TAG = "download-attachment";

    @Autowired
    private MulcaGate mulcaGate;

    private final String id;
    private final Request request;

    public CmdDownloadAttachment(AuthInfo ai, String id, Request request) {
        super(CMD_TAG, ai);
        this.id = id;
        this.request = request;
    }

    @Override
    protected void buildXmlResponseU(XmlCmdContext ctx) {
        Validate.isTrue(uidO.isPresent() && uidO.get().isYandexTeamRu());
        try {
            request.WriteFile(mulcaGate.get(id));

        } catch (Exception ex) {
            throw new CommandRunException(ex);
        }
    }
}
