package ru.yandex.calendar.frontend.web.cmd.run.ui.event.attachment;

import Yandex.Request;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.UserXmlCommand;
import ru.yandex.calendar.frontend.web.cmd.run.CommandRunException;
import ru.yandex.calendar.logic.event.attachment.MulcaGate;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.lang.Validate;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Daniel Brylev
 */
public class CmdUploadAttachment extends UserXmlCommand {
    private static final Logger logger = LoggerFactory.getLogger(CmdUploadAttachment.class);
    private static final String CMD_TAG = "upload-attachment";

    @Autowired
    private MulcaGate mulcaGate;

    private final Request request;
    private final String filePartName;

    public CmdUploadAttachment(AuthInfo authInfo, Request request, String filePartName) {
        super(CMD_TAG, authInfo);
        this.request = request;
        this.filePartName = filePartName;
    }

    @Override
    protected void buildXmlResponseU(XmlCmdContext ctx) {
        Validate.isTrue(uidO.isPresent() && uidO.get().isYandexTeamRu());
        try {
            String id = mulcaGate.put(request.getRemoteFile(filePartName));
            CalendarXmlizer.appendElm(ctx.getRootElement(), "id", id);

        } catch (Exception ex) {
            throw new CommandRunException(ex);
        }
    }
}
