package ru.yandex.calendar.frontend.web.cmd.run.ui.layer;

import Yandex.RequestPackage.RequestData;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.RequestDataConverter;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ReqProcessingXmlCommand;
import ru.yandex.calendar.logic.beans.generated.Layer;
import ru.yandex.calendar.logic.beans.generated.LayerUser;
import ru.yandex.calendar.logic.layer.LayerRequestDataConverter;
import ru.yandex.calendar.logic.layer.LayerRoutines;
import ru.yandex.calendar.logic.notification.Notification;
import ru.yandex.calendar.util.base.Binary;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;
import ru.yandex.calendar.util.data.DataProvider;
import ru.yandex.calendar.util.xml.CalendarXmlizer;

/**
 * @author ssytnik
 */
public class CmdCreateLayer extends ReqProcessingXmlCommand {
    private static final String CMD_TAG = "create-layer";

    @Autowired
    private LayerRoutines layerRoutines;

    public CmdCreateLayer(AuthInfo ai, RequestData requestData) {
        super(CMD_TAG, requestData, ai);
        setRequiresDbTransaction(true);
    }

    @Override
    protected void buildXmlResponseRP(XmlCmdContext ctx, AliasedRequestDataProvider dp) {
        DataProvider lDp = dp.getDataProvider("layer", true);
        DataProvider uDp = dp.getDataProvider("user", true);

        ListF<Notification> optNotification = RequestDataConverter
                .convertNotifications(uDp.getDataProvider("notification", false));

        Layer layer = LayerRequestDataConverter.convertLayerFromDataProvider(lDp);
        boolean isLayerDefault = Binary.parseBoolean(lDp.getText("is-default", false))
                || !layerRoutines.getDefaultLayerId(uidO.get()).isPresent();

        LayerUser luOptFields = LayerRequestDataConverter.convertLayerUserFromDataProvider(uDp);
        long id = layerRoutines.createUserLayer(uidO.get(), optNotification, layer, isLayerDefault, luOptFields);
        CalendarXmlizer.appendElm(ctx.getRootElement(), "id", id);
    }
}
