package ru.yandex.calendar.frontend.web.cmd.run.ui.layer;

import org.joda.time.Duration;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ValidatableXmlCommand;
import ru.yandex.calendar.util.dates.Timeouts;
import ru.yandex.calendar.util.validation.RequestValidator;

public class CmdDeleteLayer extends ValidatableXmlCommand {
    private static final String CMD_TAG = "delete-layer";

    private final long layerId;
    private final String newLayerIdStr;

    public CmdDeleteLayer(AuthInfo ai, long layerId, String newLayerIdStr) {
        super(CMD_TAG, ai);
        // TODO - if too many events is to be deleted, remove setRequiresDbTransaction()
        //        and use transactions for each event deletion instead
        setRequiresDbTransaction(true);
        this.layerId = layerId;
        this.newLayerIdStr = newLayerIdStr;
    }

    @Override
    public Duration getTimeout() {
        return Timeouts.getForCommand(Duration.standardSeconds(30));
    }

    @Override
    public void validate() {
        RequestValidator.validateRequired(RequestValidator.POSITIVE, "layerId", layerId);
        RequestValidator.validateOptional(RequestValidator.POSITIVE, "newLayerId", newLayerIdStr);
    }

    @Override
    protected void buildXmlResponseV(XmlCmdContext ctx) {
        throw new UnsupportedOperationException("Old api is broken. Use new api instead.");
    }
}
