package ru.yandex.calendar.frontend.web.cmd.run.ui.layer;

import java.util.Optional;

import lombok.val;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ValidatableXmlCommand;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.layer.LayerRoutines;
import ru.yandex.calendar.logic.sharing.perm.Authorizer;
import ru.yandex.calendar.logic.sharing.perm.LayerInfoForPermsCheck;
import ru.yandex.calendar.logic.sharing.perm.PermXmlizer;
import ru.yandex.calendar.micro.perm.LayerAction;
import ru.yandex.calendar.util.validation.RequestValidator;
import ru.yandex.calendar.util.xml.CalendarXmlizer;

/**
 * by layer id, returns sharing-related layer info
 */
public class CmdGetLayer extends ValidatableXmlCommand {
    private static final String CMD_TAG = "get-layer";

    @Autowired
    private Authorizer authorizer;
    @Autowired
    private LayerRoutines layerRoutines;
    @Autowired
    private PermXmlizer permXmlizer;

    private final long layerId;

    public CmdGetLayer(AuthInfo ai, long layerId) {
        super(CMD_TAG, ai);
        this.layerId = layerId;
    }

    @Override
    protected void validate() {
        RequestValidator.validateRequired(RequestValidator.POSITIVE, "layerId", layerId);
    }

    @Override
    protected void buildXmlResponseV(XmlCmdContext ctx) {
        val source = ActionSource.WEB;
        val l = layerRoutines.getLayerById(layerId);
        val layerPermInfo = LayerInfoForPermsCheck.fromLayer(l);
        userInfoO.toOptional().ifPresentOrElse(
            user -> authorizer.ensureCanPerformLayerAction(user, layerPermInfo, Optional.empty(), LayerAction.LIST, source),
            () -> authorizer.ensureCanPerformLayerAction(layerPermInfo, LayerAction.LIST, source)
        );

        val rootElement = ctx.getRootElement();
        CalendarXmlizer.appendElm(rootElement, "perm-all", "list");

        val defaultLayerIdO = layerRoutines.getDefaultLayerId(l.getCreatorUid());
        CalendarXmlizer.appendElm(rootElement, "is-default",
                defaultLayerIdO.isPresent() && defaultLayerIdO.get() == layerId);

        permXmlizer.appendLayerPermElms(rootElement, userInfoO, layerId, source,
                LayerAction.EDIT, LayerAction.DELETE, LayerAction.GRANT
        );
        rootElement.addContent(new Element("invitations"));
    }
}
