package ru.yandex.calendar.frontend.web.cmd.run.ui.layer;

import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.UserXmlCommand;
import ru.yandex.calendar.logic.beans.generated.Layer;
import ru.yandex.calendar.logic.beans.generated.LayerFields;
import ru.yandex.calendar.logic.layer.LayerRoutines;
import ru.yandex.calendar.util.xml.CalendarXmlizer;

/**
 * Returns information about layer (of any type) by its private token.
 * ssytnik, 2009-09-11: it's just the light version of uiGetLayersAP.
 * @see CmdGetLayers
 * @author ssytnik
 */
public class CmdGetLayerAP extends UserXmlCommand {
    private static final String CMD_TAG = "get-layer-ap";

    @Autowired
    private LayerRoutines layerRoutines;

    private Layer l;

    // NOTE: in fact, tzId is not needed here. But general logic requires tzId to be set.
    public CmdGetLayerAP(String tzId, String privateToken) {
        super(CMD_TAG, tzId);
        setPrivateToken(privateToken);
    }

    @Override
    protected void obtainPrivateResource(String privateToken) {
        l = layerRoutines.getByPrivateToken(privateToken);
    }

    @Override
    protected void buildXmlResponseU(XmlCmdContext ctx) {
        // NOTE: the check below is to be added together with checks @ uiObtainLayerPtk, uiExportEvents
        //layerRoutines.ensure(l, LayerType.USER, LayerType.SERVICE); // not feed
        Element eLayer = new Element("layer");
        CalendarXmlizer.appendElm(eLayer, LayerFields.NAME.column().name(), layerRoutines.evalLayerName(l, Option.empty()));
        // ssytnik: which other fields to we need?
        ctx.getRootElement().addContent(eLayer);
    }
}
