package ru.yandex.calendar.frontend.web.cmd.run.ui.layer;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ValidatableXmlCommand;
import ru.yandex.calendar.logic.layer.LayerUserDao;
import ru.yandex.calendar.util.base.Binary;
import ru.yandex.calendar.util.validation.RequestValidator;

/**
 * Sets layer with given id visible/invisible for user in his UI
 * @author ssytnik
 */
public class CmdLayerUiSetVisible extends ValidatableXmlCommand {
    private static final String CMD_TAG = "layer-ui-set-visible";

    @Autowired
    private LayerUserDao layerUserDao;

    protected final long layerId;
    protected final String isVisibleStr;

    public CmdLayerUiSetVisible(AuthInfo ai, long layerId, String isVisibleStr) {
        super(CMD_TAG, ai);
        this.layerId = layerId;
        this.isVisibleStr = isVisibleStr;
    }

    @Override
    public void validate() {
        RequestValidator.validateRequired(RequestValidator.POSITIVE, "layerId", layerId);
    }

    @Override
    protected void buildXmlResponseV(XmlCmdContext ctx) {
        layerUserDao.updateLayerUserSetVisibleInUiByLayerIdAndUid(layerId, uidO.get(), Binary.parseBoolean(isVisibleStr));
    }
}
