package ru.yandex.calendar.frontend.web.cmd.run.ui.layer;

import java.util.Optional;

import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ValidatableXmlCommand;
import ru.yandex.calendar.logic.event.ActionSource;
import ru.yandex.calendar.logic.layer.LayerRoutines;
import ru.yandex.calendar.logic.sharing.perm.Authorizer;
import ru.yandex.calendar.logic.sharing.perm.LayerInfoForPermsCheck;
import ru.yandex.calendar.micro.perm.LayerAction;
import ru.yandex.calendar.util.base.Binary;
import ru.yandex.calendar.util.validation.RequestValidator;
import ru.yandex.calendar.util.xml.CalendarXmlizer;

public class CmdObtainLayerPtk extends ValidatableXmlCommand {
    private static final String CMD_TAG = "obtain-layer-ptk";

    @Autowired
    private LayerRoutines layerRoutines;
    @Autowired
    private Authorizer authorizer;

    protected final long layerId;
    protected final String forceNewStr;

    public CmdObtainLayerPtk(AuthInfo ai, long layerId, String forceNewStr) {
        super(CMD_TAG, ai);
        this.layerId = layerId;
        this.forceNewStr = forceNewStr;
    }

    @Override
    public void validate() {
        RequestValidator.validateRequired(RequestValidator.POSITIVE, "layerId", layerId);
    }

    @Override
    protected void buildXmlResponseV(XmlCmdContext ctx) {
        val source = ActionSource.WEB;
        val layerPermInfo = LayerInfoForPermsCheck.fromLayer(layerRoutines.getLayerById(layerId));
        userInfoO.toOptional().ifPresentOrElse(
            user -> authorizer.ensureCanPerformLayerAction(user, layerPermInfo, Optional.empty(), LayerAction.GRANT, source),
            () -> authorizer.ensureCanPerformLayerAction(layerPermInfo, LayerAction.GRANT, source))
        ;
        val ptk = layerRoutines.obtainPtk(uidO.get(), layerId, Binary.parseBoolean(forceNewStr));
        CalendarXmlizer.appendElm(ctx.getRootElement(), "private-token", ptk);
    }
}
