package ru.yandex.calendar.frontend.web.cmd.run.ui.layer;

import javax.annotation.Nullable;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.UserXmlCommand;

public class CmdShareLayer extends UserXmlCommand {
    private static final String CMD_TAG = "share-layer";

    private final Option<Long> layerId;
    private final Option<String> privateToken;

    public CmdShareLayer(AuthInfo ai, @Nullable Long layerId, @Nullable String privateToken) {
        super(CMD_TAG, ai);
        this.layerId = Option.ofNullable(layerId);
        this.privateToken = Option.ofNullable(privateToken);
        setRequiresDbTransaction(true); // just in case
    }

    @Override
    protected void buildXmlResponseU(XmlCmdContext ctx) {
        throw new UnsupportedOperationException("Old api is broken. Use new api instead.");
    }
}
