package ru.yandex.calendar.frontend.web.cmd.run.ui.layer;

import Yandex.RequestPackage.RequestData;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ReqProcessingXmlCommand;
import ru.yandex.calendar.logic.layer.LayerRoutines;
import ru.yandex.calendar.logic.update.LockHandle;
import ru.yandex.calendar.logic.update.LockResource;
import ru.yandex.calendar.logic.update.UpdateLock2;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;

/**
 * @author gutman
 */
public class CmdSvcUpdateLayer extends ReqProcessingXmlCommand {
    private static final String CMD_TAG = "service-update-layer";

    @Autowired
    private LayerRoutines layerRoutines;
    @Autowired
    private UpdateLock2 updateLock2;

    public CmdSvcUpdateLayer(AuthInfo ai, RequestData requestData) {
        super(CMD_TAG, requestData, ai);
        setRequiresDbTransaction(true);
    }

    @Override
    protected void buildXmlResponseRP(XmlCmdContext ctx, AliasedRequestDataProvider dp) {
        LockHandle lock = updateLock2.lockForUpdate(Cf.list(LockResource.layerUser(uidO.get())));
        try {
            layerRoutines.updateServiceLayer(uidO.get(), dp, getActionInfo());
        } finally {
            lock.release();
        }
    }

}
