package ru.yandex.calendar.frontend.web.cmd.run.ui.resource;

import javax.annotation.Nullable;

import org.jdom.Comment;
import org.jdom.Element;
import org.joda.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.generic.UserXmlCommand;
import ru.yandex.calendar.logic.beans.generated.Office;
import ru.yandex.calendar.logic.beans.generated.OfficeFields;
import ru.yandex.calendar.logic.resource.OfficeManager;
import ru.yandex.calendar.logic.resource.ResourceDao;
import ru.yandex.calendar.logic.resource.ResourceType;
import ru.yandex.calendar.logic.user.Language;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.inside.passport.blackbox.PassportDomain;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author Stepan Koltsov
 */
public abstract class CmdGetDomainResourcesBase extends UserXmlCommand {

    @Autowired
    private ResourceDao resourceDao;
    @Autowired
    protected OfficeManager officeManager;
    @Autowired
    private SettingsRoutines settingsRoutines;

    protected final Instant now = new Instant();
    protected final Option<String> officeIdString;

    public CmdGetDomainResourcesBase(String cmdTagName, AuthInfo ai, @Nullable String officeId) {
        super(cmdTagName, ai);
        this.officeIdString = StringUtils.notEmptyO(officeId);
    }

    protected Element officesXml(Language lang) {
        Element officesElement = new Element("offices");

        officesElement.addContent(new Comment("with at least once resource only"));

        PassportDomain domain = getPassportDomain();
        ListF<Office> offices = domainOfficesWithResources(domain);

        ListF<Long> apartmentOfficeIds = officeManager.getDomainOfficesWithAtLeaseOneResourceWithType(
                uidO.get(), domain, Cf.set(ResourceType.APARTMENT, ResourceType.HOTEL, ResourceType.CAMPUS)).map(Office.getIdF());
        CalendarXmlizer.appendElmColl(officesElement, "offices-month-viewable", "id", apartmentOfficeIds);

        long defaultOffice;
        if (uidO.isPresent()) {
            defaultOffice = officeOrUserDefaultOfficeOrDomainDefaultOffice(domain);
        } else {
            defaultOffice = offices.first().getId();
        }
        officesElement.setAttribute("default-for-user-office-id",
                ResourceXmlizer.officeIdForVerstka(resourceDao.findOfficeById(defaultOffice).get()));

        officesElement.addContent(ResourceXmlizer.officeXmls(offices, lang));

        return officesElement;
    }

    protected long officeOrUserDefaultOfficeOrDomainDefaultOffice(PassportDomain domain) {
        Option<Long> office = officeOrElseUserDefaultOfficeO(domain);
        if (office.isPresent()) {
            return office.get();
        } else {
            return domainOfficesWithResources(domain).first().getId();
        }
    }

    protected Option<Long> officeOrElseUserDefaultOfficeO(PassportDomain domain) {
        Option<Long> officeIdO = officeId(domain);
        if (officeIdO.isPresent()) {
            return officeIdO;
        }
        Option<Long> defaultUserOffice = officeManager.getDefaultOfficeForUser(uidO.get()).map(OfficeFields.ID.getF());
        ListF<Office> domainOfficesWithResources = domainOfficesWithResources(domain);
        if (defaultUserOffice.isPresent() &&
                domainOfficesWithResources.map(OfficeFields.ID.getF()).containsTs(defaultUserOffice.get())) { // hack for nadomniks
            return defaultUserOffice;
        }
        return Option.empty();
    }

    private ListF<Office> offices = null;

    protected ListF<Office> domainOfficesWithResources(PassportDomain domain) {
        if (offices == null) {
            offices = officeManager.getDomainOfficesWithAtLeastOneActiveResource(uidO.get(), domain);
        }
        return offices;
    }

    private Option<Long> officeId = null;

    protected Option<Long> officeId(PassportDomain domain) {
        if (officeId == null) {
            if (!officeIdString.isPresent()) {
                officeId = Option.empty();
            } else {
                Option<Long> r = Cf.Long.parseSafe(officeIdString.get());
                if (r.isPresent()) {
                    officeId = r;
                } else {
                    officeId = Option.of(resourceDao.findOfficeByAbbr(officeIdString.get(), domain).get().getId());
                }
            }
        }
        return officeId;
    }

    protected PassportDomain getPassportDomain() {
        if (!uidO.isPresent()) {
            return PassportDomain.YANDEX_RU;
        }

        return settingsRoutines.getPassportDomain(uidO.get());
    }

} //~
