package ru.yandex.calendar.frontend.web.cmd.run.ui.settings;

import org.jdom.Element;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.UserXmlCommand;
import ru.yandex.calendar.logic.beans.generated.Settings;
import ru.yandex.calendar.logic.beans.generated.SettingsFields;
import ru.yandex.calendar.logic.beans.generated.SettingsYt;
import ru.yandex.calendar.logic.beans.generated.SettingsYtFields;
import ru.yandex.calendar.logic.layer.LayerRoutines;
import ru.yandex.calendar.logic.notification.Notification;
import ru.yandex.calendar.logic.notification.NotificationXmlizer;
import ru.yandex.calendar.logic.resource.OfficeManager;
import ru.yandex.calendar.logic.user.SettingsInfo;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.calendar.util.base.Binary;
import ru.yandex.calendar.util.dates.AuxDateTime;
import ru.yandex.calendar.util.dates.DateTimeFormatter;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.inside.passport.PassportSid;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.email.Email;

/**
 * Ensures that user settings exist and returns them
 * @author ssytnik
 */
public class CmdGetSettings extends UserXmlCommand {
    private static final String CMD_TAG = "get-settings";

    @Autowired
    private SettingsRoutines settingsRoutines;
    @Autowired
    private LayerRoutines layerRoutines;
    @Autowired
    private OfficeManager officeManager;

    private final String forSettingsPageStr;

    public CmdGetSettings(AuthInfo ai, String forSettingsPageStr) {
        // important: ctor(..., tzId) is not used, so in the command body it is
        // possible to use dtf.getTimeZone().getId(), not s.getTimezoneJavaid()
        super(CMD_TAG, ai);
        this.forSettingsPageStr = forSettingsPageStr;
    }

    @Override
    protected void buildXmlResponseU(XmlCmdContext ctx) {
        Element eRoot = ctx.getRootElement();

        final PassportUid uid = uidO.get();
        SettingsInfo si = settingsRoutines.getSettingsByUid(uid);

        Settings s = si.getCommon();
        s.appendXmlTo(eRoot, tz,
            SettingsFields.UID, SettingsFields.IS_EDITED,
            SettingsFields.NO_NTF_START_TS, SettingsFields.NO_NTF_END_TS,
            SettingsFields.NO_NTF_START_TM, SettingsFields.NO_NTF_END_TM,
            SettingsFields.START_WEEKDAY, SettingsFields.EMAIL, SettingsFields.VIEW_TYPE
        );

        if (si.getYt().isPresent()) {
            si.getYt().get().appendXmlTo(eRoot, tz, SettingsYtFields.LET_PARTICIPANTS_EDIT);
            si.getYt().get().appendXmlTo(eRoot, tz, SettingsYtFields.XIVA_REMINDER_ENABLED);
            si.getYt().get().appendXmlTo(eRoot, tz, SettingsYtFields.REMIND_UNDECIDED);
            si.getYt().get().appendXmlTo(eRoot, tz, SettingsYtFields.NO_NTF_DURING_ABSENCE);
            s.appendXmlTo(eRoot, tz, SettingsFields.HACK_CALDAV_TIMEZONES);
        }

        // WAS (see dtf.appendTzInfo(...): dtf.appendTzOffsets(rootElement);
        DateTimeFormatter.appendTzInfo(tz, eRoot, "timezone-javaid", true, null);
        s.appendXmlTo(eRoot, tz,
            SettingsFields.GEO_TZ_JAVAID, SettingsFields.GRID_TOP_HOURS, SettingsFields.TRANSLIT_SMS,
            SettingsFields.MAPS_ENABLED, SettingsFields.SHOW_AVAILABILITY, SettingsFields.SHOW_AVATARS,
            SettingsFields.SHOW_TODO, SettingsFields.INV_ACCEPT_TYPE, SettingsFields.LANGUAGE
        );
        Option<String> officeTzId = si.getYt().filterMap(SettingsYt.getActiveOfficeIdF())
                .map(officeManager.getTimeZoneByOfficeIdF().andThen(AuxDateTime.getTzIdF()));
        CalendarXmlizer.appendElm(eRoot, "office-timezone-id", officeTzId.getOrNull());

        Option<Long> layerIdO = layerRoutines.getDefaultLayerId(uidO.get());
        // Temporary solution for https://jira.yandex-team.ru/browse/CAL-3947
        CalendarXmlizer.appendDtfElm(eRoot, "layer-id", layerIdO.getOrNull(), tz);
        //settingsRoutines.appendHasMobilePhoneElm(rootElement, uid);
        //logger.debug("Settings received, fetching notification");
        ListF<Notification> n = layerRoutines.getNotificationOrGetDefaultBySid(uid, PassportSid.CALENDAR);
        NotificationXmlizer.appendElmForCmdGetSettings(eRoot, n, true);
        // Add emails
        boolean forSettingsPage = Binary.parseBoolean(forSettingsPageStr);
        if (forSettingsPage) {
            ListF<Email> emails = userManager.getEmailsByUid(uid);
            CalendarXmlizer.appendElmColl(eRoot, null, "email", emails);
        }
        // Add current date
        CalendarXmlizer.setAttr(eRoot, "current-date", new LocalDate(tz).toString());
        CalendarXmlizer.setAttr(eRoot, "for-property-page", forSettingsPage); // XXX use similar names

        CalendarXmlizer.appendElm(eRoot, "bleeding-edge", false);
        CalendarXmlizer.appendElm(eRoot, "is-super-user", userInfoO.get().isSuperUser());
        CalendarXmlizer.appendElm(eRoot, "is-room-admin", userInfoO.get().isRoomAdmin());
        CalendarXmlizer.appendElm(eRoot, "is-yamoney-user", userManager.isYamoneyUser(uid));
        CalendarXmlizer.appendElm(eRoot, "is-external-user", userInfoO.get().isExternalYt());
    }
}
