package ru.yandex.calendar.frontend.web.cmd.run.ui.settings;

import Yandex.RequestPackage.RequestData;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ReqProcessingXmlCommand;
import ru.yandex.calendar.logic.update.LockResource;
import ru.yandex.calendar.logic.update.LockTransactionManager;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;

/**
 * Updates user settings (including notification)
 * @author ssytnik
 */
public class CmdUpdateSettings extends ReqProcessingXmlCommand {
    private static final String CMD_TAG = "update-settings";

    @Autowired
    private SettingsRoutines settingsRoutines;
    @Autowired
    private LockTransactionManager lockTransactionManager;

    public CmdUpdateSettings(AuthInfo ai, RequestData requestData) {
        super(CMD_TAG, requestData, ai);
    }

    @Override
    protected void buildXmlResponseRP(XmlCmdContext ctx, final AliasedRequestDataProvider dp) {
        lockTransactionManager.lockAndDoInTransaction(LockResource.settingsUser(uidO.get()),
                () -> settingsRoutines.update(uidO.get(), dp, tz));
    }

}
