package ru.yandex.calendar.frontend.web.cmd.run.ui.settings;

import Yandex.RequestPackage.RequestData;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ReqProcessingXmlCommand;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;

/**
 * Update one or a part of optional user settings
 * @author akirakozov
 *
 */
public class CmdUpdateSettingsOpt extends ReqProcessingXmlCommand {
    private static final String CMD_TAG = "udpate-settings-opt";

    @Autowired
    private SettingsRoutines settingsRoutines;

    public CmdUpdateSettingsOpt(AuthInfo ai, RequestData requestData) {
        super(CMD_TAG, requestData, ai);
        setRequiresDbTransaction(true);
    }

    @Override
    protected void buildXmlResponseRP(XmlCmdContext ctx, AliasedRequestDataProvider dp) {
        settingsRoutines.updateOpt(uidO.get(), dp);
    }
}
