package ru.yandex.calendar.frontend.web.cmd.run.ui.settings;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function0V;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ValidatableXmlCommand;
import ru.yandex.calendar.logic.update.LockResource;
import ru.yandex.calendar.logic.update.LockTransactionManager;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.calendar.util.validation.RequestValidator;
import ru.yandex.misc.lang.StringUtils;

/**
 * Updates user timezone to given one (timezoneId), if requested.
 * In any case, updates geobase timezone (geoTzId).
 * @author ssytnik
 */
public class CmdUpdateTimezone extends ValidatableXmlCommand {
    private static final String CMD_TAG = "update-timezone";

    @Autowired
    private SettingsRoutines settingsRoutines;
    @Autowired
    private LockTransactionManager lockTransactionManager;

    private final String geoTzId;
    private final String timezoneId;

    public CmdUpdateTimezone(
            AuthInfo ai,
            String geoTzId, String timezoneId) {

        super(CMD_TAG, ai);
        this.geoTzId = geoTzId;
        this.timezoneId = timezoneId; // optional
    }

    @Override
    public void validate() {
        RequestValidator.validateRequired(null, "geoTzId", geoTzId);
    }

    @Override
    protected void buildXmlResponseV(XmlCmdContext ctx) {
        lockTransactionManager.lockAndDoInTransaction(LockResource.settingsUser(uidO.get()), new Function0V() {
            public void apply() {
                settingsRoutines.updateTimezones(uidO.get(), StringUtils.notEmptyO(timezoneId), Option.of(geoTzId));
            }
        });
    }
}
