package ru.yandex.calendar.frontend.web.cmd.run.ui.todo;

import Yandex.RequestPackage.RequestData;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ReqProcessingXmlCommand;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;
import ru.yandex.calendar.util.xml.CalendarXmlizer;

/**
 * @author ssytnik
 */
public class CmdCreateTodoItem extends ReqProcessingXmlCommand {
    private static final String CMD_TAG = "create-todo-item";

    @Autowired
    private TodoRoutines todoRoutines;

    public CmdCreateTodoItem(AuthInfo ai, RequestData requestData) {
        super(CMD_TAG, requestData, ai);
        setRequiresDbTransaction(true); // for more proper getting 'pos'
    }

    @Override
    protected void buildXmlResponseRP(XmlCmdContext ctx, AliasedRequestDataProvider dp) {
        long id = todoRoutines.createTodoItem(uidO.get(), dp, tz, getActionInfo());
        CalendarXmlizer.appendElm(ctx.getRootElement(), "id", id);
    }
}
