package ru.yandex.calendar.frontend.web.cmd.run.ui.todo;

import Yandex.RequestPackage.RequestData;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.RequestDataConverter;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ReqProcessingXmlCommand;
import ru.yandex.calendar.logic.beans.generated.TodoList;
import ru.yandex.calendar.logic.event.dao.EventDao;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;
import ru.yandex.calendar.util.xml.CalendarXmlizer;

/**
 * @author ssytnik
 */
public class CmdCreateTodoList extends ReqProcessingXmlCommand {
    private static final String CMD_TAG = "create-todo-list";

    @Autowired
    private TodoRoutines todoRoutines;
    @Autowired
    private EventDao eventDao;

    public CmdCreateTodoList(AuthInfo ai, RequestData requestData) {
        super(CMD_TAG, requestData, ai);
        setRequiresDbTransaction(true); // for event attach (if error, then todo list is not created)
    }

    @Override
    protected void buildXmlResponseRP(XmlCmdContext ctx, AliasedRequestDataProvider dp) {
        TodoList todoListData = RequestDataConverter.convertTodoList(dp);
        long id = todoRoutines.createTodoList(uidO.get(), todoListData, getActionInfo());
        CalendarXmlizer.appendElm(ctx.getRootElement(), "id", id);
    }
}
