package ru.yandex.calendar.frontend.web.cmd.run.ui.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ValidatableXmlCommand;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.logic.todo.id.TodoIdOrExternalId;
import ru.yandex.calendar.util.validation.RequestValidator;
import ru.yandex.calendar.util.xml.CalendarXmlizer;

/**
 *
 * @author akirakozov
 */
public class CmdDeleteTodoItem extends ValidatableXmlCommand {
    private static final String CMD_TAG = "delete-todo-item";

    @Autowired
    private TodoRoutines todoRoutines;

    private final long todoItemId;

    public CmdDeleteTodoItem(AuthInfo ai, long todoItemId) {
        super(CMD_TAG, ai);
        this.todoItemId = todoItemId;
    }

    @Override
    public void validate() {
        RequestValidator.validateRequired(RequestValidator.POSITIVE, "todoItemId", todoItemId);
    }

    @Override
    protected void buildXmlResponseV(XmlCmdContext ctx) {
        todoRoutines.deleteTodoItemsByIds(uidO.get(), Cf.list(TodoIdOrExternalId.id(todoItemId)), getActionInfo());
        CalendarXmlizer.appendElmColl(ctx.getRootElement(), null, "id", Cf.list(todoItemId));
    }
}
