package ru.yandex.calendar.frontend.web.cmd.run.ui.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ValidatableXmlCommand;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.logic.todo.id.ListIdOrExternalId;
import ru.yandex.calendar.util.validation.RequestValidator;
import ru.yandex.calendar.util.xml.CalendarXmlizer;

/**
 * @author ssytnik
 */
public class CmdDeleteTodoList extends ValidatableXmlCommand {
    private static final String CMD_TAG = "delete-todo-list";

    @Autowired
    private TodoRoutines todoRoutines;

    private final long todoListId;

    public CmdDeleteTodoList(AuthInfo ai, long todoListId) {
        super(CMD_TAG, ai);
        this.todoListId = todoListId;
        setRequiresDbTransaction(true); // just in case
    }

    @Override
    public void validate() {
        RequestValidator.validateRequired(RequestValidator.POSITIVE, "todoListId", todoListId);
    }

    @Override
    protected void buildXmlResponseV(XmlCmdContext ctx) {
        todoRoutines.deleteTodoList(uidO.get(), ListIdOrExternalId.id(todoListId), getActionInfo());
        CalendarXmlizer.appendElmArray(ctx.getRootElement(), null, "id", new Long[]{todoListId});
    }
}
