package ru.yandex.calendar.frontend.web.cmd.run.ui.todo;

import org.jdom.Text;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ValidatableXmlCommand;
import ru.yandex.calendar.logic.ics.exp.IcsTodoExporter;
import ru.yandex.calendar.logic.ics.iv5j.ical.IcsCalendar;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.util.base.AuxColl;
import ru.yandex.calendar.util.validation.RequestValidator;
import ru.yandex.inside.passport.PassportUid;

/**
 * @author ssytnik
 */
public class CmdExportTodos extends ValidatableXmlCommand {
    private static final String CMD_TAG = "export-todos";

    @Autowired
    private IcsTodoExporter icsTodoExporter;
    @Autowired
    private TodoRoutines todoRoutines;

    private String todoListIdsStr;
    private Option<PassportUid> uid2;

    public CmdExportTodos(AuthInfo ai, String todoListIdsStr) {
        super(CMD_TAG, ai);
        this.todoListIdsStr = todoListIdsStr;
        this.uid2 = uidO;
    }

    public CmdExportTodos(String privateToken, String todoListIdsStr) {
        super(CMD_TAG);
        this.todoListIdsStr = todoListIdsStr;
        setPrivateToken(privateToken);
    }

    @Override
    protected void obtainPrivateResource(String privateToken) {
        uid2 = Option.of(todoRoutines.getUidByExportToken(privateToken));
    }

    @Override
    public void validate() {
        RequestValidator.validate(RequestValidator.LONG_ARRAY, "todoListIds", todoListIdsStr);
    }

    @Override
    protected void buildXmlResponseV(XmlCmdContext ctx) {
        ListF<Long> todoListIds = AuxColl.splitToLongArray(todoListIdsStr);
        IcsCalendar icsStr = icsTodoExporter.createCalendarWithTodoItemsByIds(uid2.get(), todoListIds);
        ctx.getRootElement().addContent(new Text(icsStr.serializeToString()));
    }

}
