package ru.yandex.calendar.frontend.web.cmd.run.ui.todo;

import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ValidatableXmlCommand;
import ru.yandex.calendar.logic.beans.generated.TodoList;
import ru.yandex.calendar.logic.beans.generated.TodoListFields;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.util.validation.RequestValidator;
import ru.yandex.calendar.util.xml.CalendarXmlizer;

/**
 * @author akirakozov, ssytnik
 */
public class CmdGetAvailTodoLists extends ValidatableXmlCommand {
    private static final String CMD_TAG = "get-avail-todo-lists";

    @Autowired
    private TodoRoutines todoRoutines;

    private final String eventIdStr;

    public CmdGetAvailTodoLists(AuthInfo ai, String eventIdStr) {
        super(CMD_TAG, ai);
        this.eventIdStr = eventIdStr;
    }

    @Override
    protected void validate() {
        RequestValidator.validateOptional(RequestValidator.POSITIVE, "eventId", eventIdStr);
    }

    @Override
    protected void buildXmlResponseV(XmlCmdContext ctx) {
        Element rootElement = ctx.getRootElement();
        CalendarXmlizer.setAttr(rootElement, "event-id", eventIdStr);

        ListF<TodoList> lists = todoRoutines.getNonDeletedTodoLists(uidO.get());

        Element listsElement = CalendarXmlizer.appendElm(rootElement, "todo-lists");
        CalendarXmlizer.setAttr(listsElement, "count", lists.size());

        for (TodoList list : lists) {
            Element listElement = CalendarXmlizer.appendElm(listsElement, "todo-list");
            list.appendXmlTo(listElement, tz, TodoListFields.ID, TodoListFields.TITLE);
        }
    }
}
