package ru.yandex.calendar.frontend.web.cmd.run.ui.todo;

import org.jdom.Element;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Option;
import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ValidatableXmlCommand;
import ru.yandex.calendar.logic.beans.generated.SettingsFields;
import ru.yandex.calendar.logic.event.grid.ViewType;
import ru.yandex.calendar.logic.todo.TodoListsXmlAppender;
import ru.yandex.calendar.logic.todo.TodoListsXmlAppender.Mode;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.logic.user.SettingsRoutines;
import ru.yandex.calendar.util.dates.DateTimeFormatter;
import ru.yandex.calendar.util.validation.RequestValidator;
import ru.yandex.calendar.util.xml.CalendarXmlizer;
import ru.yandex.misc.db.q.SqlCondition;
import ru.yandex.misc.lang.StringUtils;

public class CmdGetTodoListsSchedule extends ValidatableXmlCommand {
    private static final String CMD_TAG = "get-todo-lists-schedule";

    @Autowired
    private SettingsRoutines settingsRoutines;
    @Autowired
    private TodoListsXmlAppender todoListsXmlAppender;
    @Autowired
    private TodoRoutines todoRoutines;

    private final String viewTypeStr;
    private final String showDateStr;

    public CmdGetTodoListsSchedule(
            AuthInfo ai,
            String showDateStr, String viewType)
    {
        super(CMD_TAG, ai);
        this.viewTypeStr = viewType;
        this.showDateStr = showDateStr;
    }

    @Override
    public void validate() {
        RequestValidator.validateOptional(RequestValidator.DATE, "showDate", showDateStr);
        RequestValidator.validateOptional(ViewType.AV, "viewType", viewTypeStr);
    }

    @Override
    protected void buildXmlResponseV(XmlCmdContext ctx) {
        Element rootElement = ctx.getRootElement();
        ViewType vt = StringUtils.isNotEmpty(viewTypeStr)
                ? ViewType.R.valueOf(viewTypeStr)
                : settingsRoutines.getSettingsField(uidO.get(), SettingsFields.VIEW_TYPE);
        LocalDate showDate = DateTimeFormatter.toDate(showDateStr, new LocalDate(tz));
        CalendarXmlizer.appendElm(rootElement, "todo-view-type", vt.toDbValue());
        CalendarXmlizer.appendElm(rootElement, "show-date", showDateStr);
        CalendarXmlizer.appendElm(rootElement, "export-token", todoRoutines.obtainTodoExportToken(uidO.get()).getOrElse(""));

        SqlCondition createItemCondBuilder = TodoRoutines.createItemCondBuilder(tz, showDate, vt,
                settingsRoutines.getSettingsField(uidO.get(), SettingsFields.START_WEEKDAY));
        Mode mode = TodoListsXmlAppender.Mode.FOR_SCHEDULE;
        todoListsXmlAppender.appendXml(rootElement, uidO.get(), tz, mode, Option.<Long>empty(), createItemCondBuilder);
    }
}
