package ru.yandex.calendar.frontend.web.cmd.run.ui.todo;

import Yandex.RequestPackage.RequestData;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ReqProcessingXmlCommand;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;

/**
 * Changes order of open todo items in todo list.
 * @author ssytnik, akirakozov
 */
public class CmdReorderTodoItems extends ReqProcessingXmlCommand {
    private static final String CMD_TAG = "reorder-todo-items";

    @Autowired
    private TodoRoutines todoRoutines;

    public CmdReorderTodoItems(AuthInfo ai, RequestData requestData) {
        super(CMD_TAG, requestData, ai);
        setRequiresDbTransaction(true);
    }

    @Override
    protected void buildXmlResponseRP(XmlCmdContext ctx, AliasedRequestDataProvider dp) {
        todoRoutines.reorder(uidO.get(), dp, getActionInfo());
    }
}
