package ru.yandex.calendar.frontend.web.cmd.run.ui.todo;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ValidatableXmlCommand;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.logic.todo.id.TodoIdOrExternalId;
import ru.yandex.calendar.util.base.Binary;
import ru.yandex.calendar.util.validation.RequestValidator;

/**
 * Sets layer with given id visible or invisible in UI for user
 * @author ssytnik
 */
public class CmdTodoItemSetIsCmpl extends ValidatableXmlCommand {
    private static final String CMD_TAG = "todo-item-set-is-completed";

    @Autowired
    private TodoRoutines todoRoutines;

    protected final long todoItemId;
    protected final String isCompletedStr;

    public CmdTodoItemSetIsCmpl(AuthInfo ai, long todoItemId, String isCompletedStr) {
        super(CMD_TAG, ai);
        this.todoItemId = todoItemId;
        this.isCompletedStr = isCompletedStr;
    }

    @Override
    public void validate() {
        RequestValidator.validateRequired(RequestValidator.POSITIVE, "todoItemId", todoItemId);
    }

    @Override
    protected void buildXmlResponseV(XmlCmdContext ctx) {
        todoRoutines.updateTodoItemSetCompleted(
                uidO.get(), TodoIdOrExternalId.id(todoItemId), Binary.parseBoolean(isCompletedStr), getActionInfo());
    }
}
