package ru.yandex.calendar.frontend.web.cmd.run.ui.todo;

import Yandex.RequestPackage.RequestData;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ReqProcessingXmlCommand;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;

/**
 * Updates todo list and todo items.
 * Note that due to look-and-feel peculiarities, some limitations
 * are applied to the update. First of all, only open (is_completed = 0)
 * items are edited. The title and description of list and also title of
 * the items can be changed.
 * @author ssytnik, akirakozov
 */
public class CmdUpdateTodoAll extends ReqProcessingXmlCommand {
    private static final String CMD_TAG = "update-todo-all";

    @Autowired
    private TodoRoutines todoRoutines;

    public CmdUpdateTodoAll(AuthInfo ai, RequestData requestData) {
        super(CMD_TAG, requestData, ai);
        setRequiresDbTransaction(true);
    }

    @Override
    protected void buildXmlResponseRP(XmlCmdContext ctx, AliasedRequestDataProvider dp) {
        todoRoutines.updateAll(uidO.get(), dp, getActionInfo());
    }
}
