package ru.yandex.calendar.frontend.web.cmd.run.ui.todo;

import Yandex.RequestPackage.RequestData;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.calendar.frontend.web.AuthInfo;
import ru.yandex.calendar.frontend.web.cmd.ctx.XmlCmdContext;
import ru.yandex.calendar.frontend.web.cmd.generic.ReqProcessingXmlCommand;
import ru.yandex.calendar.logic.todo.TodoRoutines;
import ru.yandex.calendar.util.data.AliasedRequestDataProvider;

/**
 *
 * @author akirakozov
 */
public class CmdUpdateTodoItem extends ReqProcessingXmlCommand {
    private static final String CMD_TAG = "update-todo-item";

    @Autowired
    private TodoRoutines todoRoutines;

    public CmdUpdateTodoItem(AuthInfo ai, RequestData requestData) {
        super(CMD_TAG, requestData, ai);
        setRequiresDbTransaction(true); // for more proper getting 'pos'
    }

    @Override
    protected void buildXmlResponseRP(XmlCmdContext ctx, AliasedRequestDataProvider dp) {
        todoRoutines.updateTodoItem(uidO.get(), dp, tz, getActionInfo());
    }
}
